#include <amxmodx>
#include <amxmisc>
#include <core>
#include <engine>
#include <fakemeta>
#include <nvault>

#define PLUGIN	"Map On Time"
#define AUTHOR	"Trofian"
#define VERSION	"1.5"

#define IsPlayer(%1) (1 <= (%1) <= 32)
#pragma tabsize 0

// global  constants
#define PATH_CFG "mot.ini"

// global  variables
new g_massParams[32][32]
new g_countParams
new g_standartTimeleft

new g_startTime_h[32]
new g_stopTime_h[32]
new g_startTime_m[32]
new g_stopTime_m[32]
new g_map[32][32]

new g_nowMap[32]
new g_nowStartTime_h
new g_nowStopTime_h
new g_nowStartTime_m
new g_nowStopTime_m

new g_nextMap[32]
new g_nextStartTime_h
new g_nextStopTime_h
new g_nextStartTime_m
new g_nextStopTime_m

new bool:g_b_motModeOn = false
new bool:g_b_hookTimeleft = false
new bool:g_b_showhud = false

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("mp_timelimit","20")
	register_cvar("mot_show_hud","1")
	register_cvar("mot_light","0")
	register_dictionary("mot.txt")
	register_dictionary("timeleft.txt")
	register_concmd("amx_mot","moton", ADMIN_SLAY,"<on/off>")
	register_clcmd("say timeleft", "show_timeleft")
	register_clcmd("say_team timeleft", "show_timeleft")
	g_standartTimeleft = get_cvar_num("mp_timelimit")
	read_cfg_and_calls()
}

public read_cfg_and_calls()
{
	// func var's
	new f_configsDir[64]
	new f_numSymb
	new f_line = 0
	new f_textline[32]
	new f_period = 0
	//-------------------
	
	get_configsdir(f_configsDir, 63)
	format(f_configsDir, 63, "%s/%s", f_configsDir, PATH_CFG)
	
		if (!file_exists(f_configsDir))
		{
			server_print("[%s] File ^"%s^" doesn't exist.", PLUGIN, f_configsDir) 
			return PLUGIN_HANDLED
		}
		
		while (f_line = read_file (f_configsDir, f_line, f_textline, 255, f_numSymb))
		{
			g_massParams[f_period] = f_textline
			analysisOfParameters(f_period)
			f_period = f_period + 1
		}
		g_countParams = f_period-1
		pre_chek()
		return PLUGIN_CONTINUE
}

public analysisOfParameters(num)
{	
	// func var's
	new f_all[32]
	new f_temp[6]
	//-------------------

	f_all = g_massParams[num]
	
	// start time h & convert
	format(f_temp,5,"%s%s",f_all[0], f_all[1])
	g_startTime_h[num] = str_to_num(f_temp)
	
	// stop time h & convert
	format(f_temp,5,"%s%s",f_all[6], f_all[7])
	g_stopTime_h[num] = str_to_num(f_temp)
	
	// start time m & convert
	format(f_temp,5,"%s%s",f_all[3], f_all[4])
	g_startTime_m[num] = str_to_num(f_temp)
	
	// stop time m & convert
	format(f_temp, 5,"%s%s",f_all[9], f_all[10])
	g_stopTime_m[num] = str_to_num(f_temp)
	
	// map name
	for (new i = 0; i<20; i++)
	{
		g_map[num][i] = f_all[i+12]
	}
	
	return PLUGIN_CONTINUE
}

public pre_chek()
{		
	if (g_countParams+1 == 0)
	{
		server_print("[%s] Error: Config file is empty!", PLUGIN)
		return PLUGIN_HANDLED
	}

	if(g_countParams+1 < 0)
	{
		server_print("[%s] Error: Unknown error! (debug: g_countParams = %d)", PLUGIN, g_countParams)
		return PLUGIN_HANDLED
	}
	
	if(g_countParams+1 >= 1)
	{
		set_task (5.0, "chek_and_show")
	}
	return PLUGIN_CONTINUE
}

public chek_and_show()
{
	// func var's
	new f_timeHours
	new f_timeMinutes
	new f_map[32]
	new f_nowStartTime[32]
	new f_nowStopTime[32]
	new f_nextStartTime[32]
	new f_nextStopTime[32]
	//-------------------
	
	set_task (25.0, "chek_and_show")
	time (f_timeHours, f_timeMinutes)
	get_mapname(f_map, 31)
	
	for (new i = 0; i<=g_countParams; i++)
	{	
		if(f_timeHours == g_startTime_h[i] && f_timeMinutes == g_startTime_m[i])
		{	
			if(g_b_motModeOn == true || equali(f_map, g_map[i]))
			{	
				g_b_motModeOn = true
				g_nowMap = g_map[i]
				g_nowStartTime_h = g_startTime_h[i]
				g_nowStopTime_h = g_stopTime_h[i]
				g_nowStartTime_m = g_startTime_m[i]
				g_nowStopTime_m = g_stopTime_m[i]
				
				g_nextMap = g_map[i+1]
				g_nextStartTime_h = g_startTime_h[i+1]
				g_nextStopTime_h = g_stopTime_h[i+1]
				g_nextStartTime_m = g_startTime_m[i+1]
				g_nextStopTime_m = g_stopTime_m[i+1]
				
				g_b_hookTimeleft = true
				g_b_showhud = true
				server_cmd("mp_timelimit 0")
					switch (get_cvar_num("mot_light"))
					{
						case 0:
							{
								// nothing
							}
		
						case 1:
							{
								engfunc(EngFunc_LightStyle, 0, 107)
							}
		
						case 2:
							{
								engfunc(EngFunc_LightStyle, 0, 105)
							}
		
						case 3:
							{
								engfunc(EngFunc_LightStyle, 0, 103)
							}
					}
			}else{	
				server_cmd("changelevel %s", g_map[i])
			}
		}
		else if(f_timeHours == g_stopTime_h[i] && f_timeMinutes == g_stopTime_m[i])
		{
			if(g_b_motModeOn == true)
			{
				server_cmd("mp_timelimit %d", g_standartTimeleft)
				g_b_motModeOn = false
			}
			g_b_motModeOn = false
			g_b_showhud = false
			g_b_hookTimeleft = false
		}
		
		if(g_b_showhud == true && get_cvar_num("mot_show_hud") == 1)
		{
				format(f_nowStartTime, 31, "%d", g_nowStartTime_m)
				format(f_nowStopTime, 31, "%d", g_nowStopTime_m)
				format(f_nextStartTime, 31, "%d", g_nextStartTime_m)
				format(f_nextStopTime, 31, "%d", g_nextStopTime_m)
				
				if(g_nowStartTime_m >=0 && g_nowStartTime_m <= 9)
					format(f_nowStartTime, 31, "0%d", g_nowStartTime_m)
				if(g_nowStopTime_m >=0 && g_nowStopTime_m <= 9)
					format(f_nowStopTime, 31, "0%d", g_nowStopTime_m)
				if(g_nextStartTime_m >=0 && g_nextStartTime_m <= 9)
					format(f_nextStartTime, 31, "0%d", g_nextStartTime_m)
				if(g_nextStopTime_m >=0 && g_nextStopTime_m <= 9)
					format(f_nextStopTime, 31, "0%d", g_nextStopTime_m)
				
			if(g_nowStopTime_h == g_nextStartTime_h && g_nowStopTime_m == g_nextStartTime_m)
				{
					set_hudmessage(0, 255, 0, 0.16, 0.0, 0, 26.0, 26.0, 0.1, 0.1, -1)
					show_hudmessage (0, "%L %s^n%L %d:%s %L %d:%s^n" ,LANG_PLAYER, "HUD_MESSAGE_ON", g_nowMap , LANG_PLAYER,"HUD_MESSAGE_ON_BEGIN", g_nowStartTime_h,  f_nowStartTime, LANG_PLAYER,"HUD_MESSAGE_ON_END", g_nowStopTime_h, f_nowStopTime)	
					set_hudmessage(0, 255, 0, 0.50, 0.0, 0, 26.0, 26.0, 0.1, 0.1, -1)
					show_hudmessage (0, "%L %s^n%L %d:%s %L %d:%s^n" ,LANG_PLAYER, "HUD_MESSAGE_NEXT_MAP", g_nextMap , LANG_PLAYER,"HUD_MESSAGE_ON_BEGIN", g_nextStartTime_h, f_nextStartTime, LANG_PLAYER,"HUD_MESSAGE_ON_END", g_nextStopTime_h, f_nextStopTime)
					}else{
					set_hudmessage(0, 255, 0, 0.16, 0.0, 0, 26.0, 26.0, 0.1, 0.1, -1)
					show_hudmessage (0, "%L %s^n%L %d:%s %L %d:%s^n" ,LANG_PLAYER, "HUD_MESSAGE_ON", g_nowMap , LANG_PLAYER,"HUD_MESSAGE_ON_BEGIN", g_nowStartTime_h,  f_nowStartTime, LANG_PLAYER,"HUD_MESSAGE_ON_END", g_nowStopTime_h, f_nowStopTime)		
				}
		}
	}
}

public show_timeleft(id)
{
	if (g_b_hookTimeleft == true)
	{
		// func var's
		new f_text[32]
		new f_nowStartTime[32]
		new f_nowStopTime[32]
		//-------------------
		
		format(f_nowStartTime, 31, "%d", g_nowStartTime_m)
		format(f_nowStopTime, 31, "%d", g_nowStopTime_m)
		if(g_nowStartTime_m >=0 && g_nowStartTime_m <= 9)
			format(f_nowStartTime, 31, "0%d", g_nowStartTime_m)
		if(g_nowStopTime_m >=0 && g_nowStopTime_m <= 9)
			format(f_nowStopTime, 31, "0%d", g_nowStopTime_m)
		
		format (f_text, 31, "%L", LANG_PLAYER, "NO_T_LIMIT")
		
		client_print(id, print_chat, "%L %s %L %d:%s %L %d:%s", LANG_PLAYER, "CHAT_PRINT", g_nowMap, LANG_PLAYER, "HUD_MESSAGE_ON_BEGIN", g_nowStartTime_h, f_nowStartTime, LANG_PLAYER, "HUD_MESSAGE_ON_END", g_nowStopTime_h, f_nowStopTime)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public moton(id, level, cid)
{
	if (!cmd_access(id, level, cid, 3))
		return PLUGIN_HANDLED
   
	// func var's
	new f_a_motoffon[16]
	//-------------------
   
	read_argv(1, f_a_motoffon, 15)
   
	if(equali(f_a_motoffon, "off"))
	{
		server_cmd("mp_timelimit %d", g_standartTimeleft)
		g_b_motModeOn = false
		g_b_showhud = false
		g_b_hookTimeleft = false
		engfunc(EngFunc_LightStyle, 0, 109)
		client_print(id, print_console, "[%s] Night Mode stoped^n[%s] In 25 seconds hud will off", PLUGIN, PLUGIN)
	}else{
		client_print(id, print_console, "[%s] What... What do you want?^n[%s] You can stop Night mode: ^"amx_mot off^"", PLUGIN, PLUGIN)
	}
	return PLUGIN_CONTINUE
}